package com.example.biblioteca

import com.google.gson.GsonBuilder
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST

// Como todas las clases de datos (Book, Category, etc.) están ahora en el mismo paquete,
// ya no es necesario importarlas. El código se vuelve más limpio.

private const val BASE_URL = "https://rosalea.grupodvh.com/biblioteca_api/"


// --- CONFIGURACIÓN AVANZADA DE RETROFIT PARA DEPURACIÓN ---
// Creamos un analizador de JSON (Gson) que es "indulgente" (lenient).
// ¡OJO! Esto es una MALA PRÁCTICA para una app en producción, pero es una
// EXCELENTE HERRAMIENTA DE DEPURACIÓN para nosotros ahora. Nos permitirá
// ver los mensajes de error de PHP que están rompiendo el formato JSON.
private val gson = GsonBuilder()
    .setLenient()
    .create()

private val retrofit = Retrofit.Builder()
    // Usamos el analizador indulgente que acabamos de crear
    .addConverterFactory(GsonConverterFactory.create(gson))
    .baseUrl(BASE_URL)
    .build()

interface ApiService {
    @GET("categories.php")
    suspend fun getCategories(): List<Category>

    @GET("books.php")
    suspend fun getBooks(): List<Book>

    @POST("login.php")
    suspend fun login(@Body request: LoginRequest): AuthResponse

    @POST("register.php")
    suspend fun register(@Body request: RegisterRequest): AuthResponse
}

object Api {
    val retrofitService: ApiService by lazy {
        retrofit.create(ApiService::class.java)
    }
}
