package com.example.biblioteca.navigation

import androidx.compose.runtime.Composable
import androidx.lifecycle.viewmodel.compose.viewModel
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.rememberNavController
// Se importan todas las clases desde el paquete principal "com.example.biblioteca"
import com.example.biblioteca.AuthViewModel
import com.example.biblioteca.BookDetailsScreen
import com.example.biblioteca.BookViewModel
import com.example.biblioteca.BooksScreen
import com.example.biblioteca.CategoryBooksScreen
import com.example.biblioteca.CategoryScreen
import com.example.biblioteca.CategoryViewModel
import com.example.biblioteca.LoansScreen
import com.example.biblioteca.LoginScreen
import com.example.biblioteca.UsersScreen
import com.example.biblioteca.WelcomeScreen

@Composable
fun AppNavigation() {
    val navController = rememberNavController()
    
    // Se instancian los ViewModels necesarios
    val bookViewModel: BookViewModel = viewModel()
    val authViewModel: AuthViewModel = viewModel() // Re-añadido para el login

    NavHost(navController = navController, startDestination = "login") {
        // Se pasa el AuthViewModel a la LoginScreen
        composable("login") { LoginScreen(navController, authViewModel) } 
        composable("welcome") { WelcomeScreen(navController) }
        // Se especifica el tipo de ViewModel para eliminar la ambigüedad
        composable("category") { CategoryScreen(navController, viewModel<CategoryViewModel>()) }
        composable("books") { BooksScreen(navController, bookViewModel) }
        composable("loans") { LoansScreen(navController) }
        composable("users") { UsersScreen(navController) }
        composable("category_books/{categoryName}") { backStackEntry ->
            val categoryName = backStackEntry.arguments?.getString("categoryName")
            CategoryBooksScreen(navController = navController, categoryName = categoryName, bookViewModel = bookViewModel)
        }
        composable("book_details/{bookId}") { backStackEntry ->
            val bookId = backStackEntry.arguments?.getString("bookId")?.toIntOrNull()
            BookDetailsScreen(navController = navController, bookId = bookId, bookViewModel = bookViewModel)
        }
    }
}
