<?php
header('Content-Type: application/json');
require_once 'db_connection.php'; // Incluimos la conexión

// Consulta con JOIN para obtener el nombre de la categoría
$sql = "SELECT b.id, b.title, b.author, b.content, c.name AS category_name
        FROM books AS b
        LEFT JOIN categories AS c ON b.category_id = c.id
        ORDER BY b.title";

$result = $conn->query($sql);

$books = [];
if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        // Aseguramos que el ID sea un número para evitar problemas en la app
        $row['id'] = (int)$row['id'];
        $books[] = $row;
    }
}

// Devolvemos el resultado en formato JSON
echo json_encode($books);

$conn->close();
?>