<?php
header('Content-Type: application/json');
require_once 'db_connection.php'; // Incluimos la conexión

// Función para enviar respuestas
function send_response($success, $message, $user_data = null) {$response = ['success' => $success, 'message' => $message];
    if ($user_data) $response['user'] = $user_data;
    echo json_encode($response);
}

// Recibimos los datos de la app
$data = json_decode(file_get_contents('php://input'));

if (!isset($data->email) || !isset($data->password)) {
    send_response(false, 'Faltan los campos email o password.');
    exit;
}

$email = $conn->real_escape_string($data->email);
$password = $data->password;

// Buscamos al usuario por su email
$sql = "SELECT id, name, email, password FROM users WHERE email = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
    // Verificamos la contraseña hasheada
    if (password_verify($password, $user['password'])) {
        $user_data = ['id' => $user['id'], 'name' => $user['name'], 'email' => $user['email']];
        send_response(true, 'Inicio de sesión exitoso', $user_data);
    } else {
        send_response(false, 'Contraseña incorrecta.');
    }
} else {
    send_response(false, 'El correo electrónico no está registrado.');
}

$conn->close();
?>